/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.business;

import ch.hearc.masict.jav.business.InsufficientBottleException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;

public abstract class CellarBottle
implements Serializable {
    private static final long serialVersionUID = 782149436455575262L;
    private UUID btleID = UUID.randomUUID();
    private String name = "";
    private String producer;
    private String country;
    private String region;
    private String type;
    private String[] food;
    private String description;
    private String labelFront;
    private String labelBack;
    private int contenance;
    private double alcoholPercent;
    private double price;
    private double rating;
    private int nbBtlesInStock;
    private int nbBtlesTaken;
    protected String[] typeList;
    public static final String[] defaultAttributeList = new String[]{ATTRIBUTES.access$000(ATTRIBUTES.NAME), ATTRIBUTES.access$000(ATTRIBUTES.PRODUCER), ATTRIBUTES.access$000(ATTRIBUTES.COUNTRY), ATTRIBUTES.access$000(ATTRIBUTES.TYPE), ATTRIBUTES.access$000(ATTRIBUTES.FOOD), ATTRIBUTES.access$000(ATTRIBUTES.ALCOHOL), ATTRIBUTES.access$000(ATTRIBUTES.BOTTLE_NB_STOCK), ATTRIBUTES.access$000(ATTRIBUTES.RATING), ATTRIBUTES.access$000(ATTRIBUTES.FRONT_LABEL)};
    public static final String[] allAttributeList = new String[]{ATTRIBUTES.access$000(ATTRIBUTES.values()[0]), ATTRIBUTES.access$000(ATTRIBUTES.values()[1]), ATTRIBUTES.access$000(ATTRIBUTES.values()[2]), ATTRIBUTES.access$000(ATTRIBUTES.values()[3]), ATTRIBUTES.access$000(ATTRIBUTES.values()[4]), ATTRIBUTES.access$000(ATTRIBUTES.values()[5]), ATTRIBUTES.access$000(ATTRIBUTES.values()[6]), ATTRIBUTES.access$000(ATTRIBUTES.values()[7]), ATTRIBUTES.access$000(ATTRIBUTES.values()[8]), ATTRIBUTES.access$000(ATTRIBUTES.values()[9]), ATTRIBUTES.access$000(ATTRIBUTES.values()[10]), ATTRIBUTES.access$000(ATTRIBUTES.values()[11]), ATTRIBUTES.access$000(ATTRIBUTES.values()[12]), ATTRIBUTES.access$000(ATTRIBUTES.values()[13]), ATTRIBUTES.access$000(ATTRIBUTES.values()[14]), ATTRIBUTES.access$000(ATTRIBUTES.values()[15])};
    public static final String[] modifAttributeList = new String[]{ATTRIBUTES.access$000(ATTRIBUTES.NAME), ATTRIBUTES.access$000(ATTRIBUTES.PRODUCER), ATTRIBUTES.access$000(ATTRIBUTES.COUNTRY), ATTRIBUTES.access$000(ATTRIBUTES.REGION), ATTRIBUTES.access$000(ATTRIBUTES.TYPE), ATTRIBUTES.access$000(ATTRIBUTES.FOOD), ATTRIBUTES.access$000(ATTRIBUTES.DESCRIPTION), ATTRIBUTES.access$000(ATTRIBUTES.CONTENANCE), ATTRIBUTES.access$000(ATTRIBUTES.ALCOHOL), ATTRIBUTES.access$000(ATTRIBUTES.PRICE), ATTRIBUTES.access$000(ATTRIBUTES.RATING), ATTRIBUTES.access$000(ATTRIBUTES.BOTTLE_NB_STOCK), ATTRIBUTES.access$000(ATTRIBUTES.BOTTLE_NB_TAKEN), ATTRIBUTES.access$000(ATTRIBUTES.FRONT_LABEL), ATTRIBUTES.access$000(ATTRIBUTES.BACK_LABEL)};
    public static final ATTRIBUTE_TYPES[] allAttributeTypeList = new ATTRIBUTE_TYPES[]{ATTRIBUTES.access$100(ATTRIBUTES.values()[0]), ATTRIBUTES.access$100(ATTRIBUTES.values()[1]), ATTRIBUTES.access$100(ATTRIBUTES.values()[2]), ATTRIBUTES.access$100(ATTRIBUTES.values()[3]), ATTRIBUTES.access$100(ATTRIBUTES.values()[4]), ATTRIBUTES.access$100(ATTRIBUTES.values()[5]), ATTRIBUTES.access$100(ATTRIBUTES.values()[6]), ATTRIBUTES.access$100(ATTRIBUTES.values()[7]), ATTRIBUTES.access$100(ATTRIBUTES.values()[8]), ATTRIBUTES.access$100(ATTRIBUTES.values()[9]), ATTRIBUTES.access$100(ATTRIBUTES.values()[10]), ATTRIBUTES.access$100(ATTRIBUTES.values()[11]), ATTRIBUTES.access$100(ATTRIBUTES.values()[12]), ATTRIBUTES.access$100(ATTRIBUTES.values()[13]), ATTRIBUTES.access$100(ATTRIBUTES.values()[14]), ATTRIBUTES.access$100(ATTRIBUTES.values()[15])};
    protected String[] extraAttributeList;
    protected ATTRIBUTE_TYPES[] extraAttributeTypeList;
    public static final ArrayList<String> subClassList = new ArrayList();
    protected String subClass;

    public CellarBottle() {
        this.producer = "";
        this.country = "";
        this.region = "";
        this.type = "none";
        this.food = new String[]{""};
        this.description = "";
        this.labelFront = "";
        this.labelBack = "";
        this.contenance = 0;
        this.alcoholPercent = 0.0;
        this.price = 0.0;
        this.rating = 0.0;
        this.typeList = new String[]{""};
        this.nbBtlesInStock = 1;
        this.nbBtlesTaken = 0;
        this.extraAttributeList = new String[]{""};
    }

    public CellarBottle(String name, String producer, String country, String region, String type, String[] food, String description, String labelFront, String labelBack, int contenance, double alcoholPercent, double price, double rating) {
        if (name != null) {
            this.name = name;
        }
        this.producer = "";
        if (producer != null) {
            this.producer = producer;
        }
        this.country = "";
        if (country != null) {
            this.country = country;
        }
        this.region = "";
        if (region != null) {
            this.region = region;
        }
        this.type = "none";
        if (type != null) {
            this.type = type;
        }
        this.food = new String[]{""};
        if (food != null) {
            this.food = food;
        }
        this.description = "";
        if (description != null) {
            this.description = description;
        }
        this.labelFront = labelFront;
        this.labelBack = labelBack;
        this.contenance = contenance;
        this.alcoholPercent = alcoholPercent;
        this.price = price;
        this.rating = rating;
        this.typeList = new String[]{""};
        this.nbBtlesInStock = 1;
        this.nbBtlesTaken = 0;
        this.extraAttributeList = new String[]{""};
    }

    public Object getAttribute(int attributeIndex) {
        switch (ATTRIBUTES.values()[attributeIndex]) {
            case NAME: {
                return this.name;
            }
            case PRODUCER: {
                return this.producer;
            }
            case COUNTRY: {
                return this.country;
            }
            case REGION: {
                return this.region;
            }
            case TYPE: {
                return this.type;
            }
            case FOOD: {
                return this.food;
            }
            case DESCRIPTION: {
                return this.description;
            }
            case CONTENANCE: {
                return this.contenance;
            }
            case ALCOHOL: {
                return this.alcoholPercent;
            }
            case PRICE: {
                return this.price;
            }
            case RATING: {
                return this.rating;
            }
            case BOTTLE_NB_STOCK: {
                return this.nbBtlesInStock;
            }
            case BOTTLE_NB_TAKEN: {
                return this.nbBtlesTaken;
            }
            case FRONT_LABEL: {
                return this.labelFront;
            }
            case BACK_LABEL: {
                return this.labelBack;
            }
            case TO_DRINK: {
                return this.toDrink();
            }
        }
        return null;
    }

    public String[] getDropAttributeLists(int attributeIndex) {
        switch (ATTRIBUTES.values()[attributeIndex]) {
            case TYPE: {
                return this.typeList;
            }
        }
        return null;
    }

    public void setAttribute(int attributeIndex, Object attribute) {
        switch (ATTRIBUTES.values()[attributeIndex]) {
            case NAME: {
                this.name = (String)attribute;
                break;
            }
            case PRODUCER: {
                this.producer = (String)attribute;
                break;
            }
            case COUNTRY: {
                this.country = (String)attribute;
                break;
            }
            case REGION: {
                this.region = (String)attribute;
                break;
            }
            case TYPE: {
                this.type = (String)attribute;
                break;
            }
            case FOOD: {
                this.food = (String[])attribute;
                break;
            }
            case DESCRIPTION: {
                this.description = (String)attribute;
                break;
            }
            case CONTENANCE: {
                this.contenance = (Integer)attribute;
                break;
            }
            case ALCOHOL: {
                this.alcoholPercent = (Double)attribute;
                break;
            }
            case PRICE: {
                this.price = (Double)attribute;
                break;
            }
            case RATING: {
                this.rating = (Double)attribute;
                break;
            }
            case BOTTLE_NB_STOCK: {
                this.nbBtlesInStock = (Integer)attribute;
                break;
            }
            case BOTTLE_NB_TAKEN: {
                this.nbBtlesTaken = (Integer)attribute;
                break;
            }
            case FRONT_LABEL: {
                this.labelFront = (String)attribute;
                break;
            }
            case BACK_LABEL: {
                this.labelBack = (String)attribute;
            }
        }
    }

    public String getSubClass() {
        return this.subClass;
    }

    public UUID getBtleID() {
        return this.btleID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLabelFront() {
        return this.labelFront;
    }

    public void setLabelFront(String labelFront) {
        this.labelFront = labelFront;
    }

    public String getLabelBack() {
        return this.labelBack;
    }

    public void setLabelBack(String labelBack) {
        this.labelBack = labelBack;
    }

    public int getContenance() {
        return this.contenance;
    }

    public void setContenance(int contenance) {
        this.contenance = contenance;
    }

    public double getAlcoolPercent() {
        return this.alcoholPercent;
    }

    public void setAlcoolPercent(double alcoolPercent) {
        this.alcoholPercent = alcoolPercent;
    }

    public String[] getFood() {
        return this.food;
    }

    public void setFood(String[] food) {
        this.food = food;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getAlcoholPercent() {
        return this.alcoholPercent;
    }

    public void setAlcoholPercent(double alcoholPercent) {
        this.alcoholPercent = alcoholPercent;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getRating() {
        return this.rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public String[] getTypeList() {
        return this.typeList;
    }

    public int getNbBtlesInStock() {
        return this.nbBtlesInStock;
    }

    public int getNbBtlesTaken() {
        return this.nbBtlesTaken;
    }

    public String[] getExtraAttributeList() {
        return this.extraAttributeList;
    }

    public ATTRIBUTE_TYPES[] getExtraAttributeTypeList() {
        return this.extraAttributeTypeList;
    }

    public abstract boolean toDrink();

    public abstract Object getExtraAttribute(int var1);

    public abstract void setExtraAttribute(int var1, Object var2);

    public abstract String[] getDropExtraAttributeLists(int var1);

    public abstract void updateExtraAttributeLists();

    public void addBtle() {
        ++this.nbBtlesInStock;
    }

    public void addBtle(int number) {
        this.nbBtlesInStock += number;
    }

    public void removeBtle() throws InsufficientBottleException {
        if (this.nbBtlesInStock > 0) {
            --this.nbBtlesInStock;
            ++this.nbBtlesTaken;
        } else {
            throw new InsufficientBottleException(1);
        }
    }

    public void removeBtle(int number) throws InsufficientBottleException {
        if (this.nbBtlesInStock >= number) {
            this.nbBtlesInStock -= number;
            this.nbBtlesTaken += number;
        } else {
            throw new InsufficientBottleException(number);
        }
    }

    public boolean equals(CellarBottle bottle) {
        return bottle.btleID == this.btleID;
    }

    public boolean nearEquals(CellarBottle bottle) {
        return !(!bottle.name.equalsIgnoreCase(this.name) || !bottle.producer.equalsIgnoreCase(this.producer) && !bottle.producer.isEmpty() && !this.producer.isEmpty() || !bottle.country.equalsIgnoreCase(this.country) || !bottle.region.equalsIgnoreCase(this.region) && !bottle.region.isEmpty() && !this.region.isEmpty() || bottle.contenance != this.contenance || !bottle.type.equalsIgnoreCase(this.type));
    }

    public boolean nearEquals(String name, String producer, String country, String region, String type, int contenance) {
        return !(!name.equalsIgnoreCase(this.name) || !producer.equalsIgnoreCase(this.producer) && !producer.isEmpty() && !this.producer.isEmpty() || !country.equalsIgnoreCase(this.country) || !region.equalsIgnoreCase(this.region) && !region.isEmpty() && !this.region.isEmpty() || contenance != this.contenance || !type.equalsIgnoreCase(this.type));
    }

    public static int attributeToIndex(String attributeText) {
        for (int i = 0; i < allAttributeList.length; ++i) {
            if (!allAttributeList[i].equals(attributeText)) continue;
            return i;
        }
        return -1;
    }

    public static ATTRIBUTE_TYPES attributeToType(String attributeText) {
        for (int i = 0; i < allAttributeList.length; ++i) {
            if (!allAttributeList[i].equals(attributeText)) continue;
            return allAttributeTypeList[i];
        }
        return ATTRIBUTE_TYPES.NONE;
    }

    public int extraAttributeToIndex(String attributeText) {
        for (int i = 0; i < this.getExtraAttributeList().length; ++i) {
            if (!this.getExtraAttributeList()[i].equals(attributeText)) continue;
            return i;
        }
        return -1;
    }

    public ATTRIBUTE_TYPES extraAttributeToType(String attributeText) {
        for (int i = 0; i < this.getExtraAttributeList().length; ++i) {
            if (!this.getExtraAttributeList()[i].equals(attributeText)) continue;
            return this.extraAttributeTypeList[i];
        }
        return ATTRIBUTE_TYPES.NONE;
    }

    public static enum ATTRIBUTES {
        NAME("Name", ATTRIBUTE_TYPES.TEXT),
        PRODUCER("Producer", ATTRIBUTE_TYPES.TEXT),
        COUNTRY("Country", ATTRIBUTE_TYPES.TEXT),
        REGION("Region", ATTRIBUTE_TYPES.TEXT),
        TYPE("Type", ATTRIBUTE_TYPES.DROP_DOWN),
        FOOD("Food", ATTRIBUTE_TYPES.TEXT_LIST),
        DESCRIPTION("Description", ATTRIBUTE_TYPES.BIG_TEXT),
        CONTENANCE("Contenance", ATTRIBUTE_TYPES.VALUE_INT),
        ALCOHOL("OH", ATTRIBUTE_TYPES.VALUE_PERCENT),
        PRICE("Price", ATTRIBUTE_TYPES.VALUE_MONEY),
        RATING("Rate", ATTRIBUTE_TYPES.RATE),
        BOTTLE_NB_STOCK("Stock", ATTRIBUTE_TYPES.VALUE_INT),
        BOTTLE_NB_TAKEN("Taken", ATTRIBUTE_TYPES.VALUE_INT),
        FRONT_LABEL("Front Label", ATTRIBUTE_TYPES.IMAGE_PATH),
        BACK_LABEL("Back Label", ATTRIBUTE_TYPES.IMAGE_PATH),
        TO_DRINK("To drink", ATTRIBUTE_TYPES.BOOL);

        private final String attribute;
        private final ATTRIBUTE_TYPES type;

        private ATTRIBUTES(String attribute, ATTRIBUTE_TYPES type) {
            this.attribute = attribute;
            this.type = type;
        }

        public String attribute() {
            return this.attribute;
        }

        public ATTRIBUTE_TYPES type() {
            return this.type;
        }

        static /* synthetic */ String access$000(ATTRIBUTES x0) {
            return x0.attribute;
        }

        static /* synthetic */ ATTRIBUTE_TYPES access$100(ATTRIBUTES x0) {
            return x0.type;
        }
    }

    public static enum ATTRIBUTE_TYPES {
        NONE(Object.class),
        TEXT(String.class),
        BIG_TEXT(String.class),
        TEXT_LIST(String[].class),
        DROP_DOWN(String.class),
        VALUE_DOUBLE(Double.class),
        VALUE_PERCENT(Double.class),
        VALUE_MONEY(Double.class),
        VALUE_INT(Integer.class),
        VALUE_YEAR(Integer.class),
        IMAGE_PATH(String.class),
        RATE(Double.class),
        BOOL(Boolean.class);

        private final Class attributeClass;

        private ATTRIBUTE_TYPES(Class attributeClass) {
            this.attributeClass = attributeClass;
        }

        public Class attributeClass() {
            return this.attributeClass;
        }
    }
}

