/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.business;

import ch.hearc.masict.jav.business.CellarBottle;
import ch.hearc.masict.jav.business.CellarStatistics;
import ch.hearc.masict.jav.business.InsufficientBottleException;
import ch.hearc.masict.jav.business.SimilarBottleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.table.AbstractTableModel;

public class CellarModel
extends AbstractTableModel {
    private ArrayList<String> currentAttributeList;
    private CopyOnWriteArrayList<CellarBottle> myCellar;
    private CellarStatistics myCellarStats;

    public CellarModel(CopyOnWriteArrayList<CellarBottle> myCellar) {
        this.myCellar = myCellar;
        this.currentAttributeList = new ArrayList<String>(Arrays.asList(CellarBottle.defaultAttributeList));
        this.myCellarStats = new CellarStatistics();
        this.myCellarStats.updateStatistics(myCellar);
    }

    public CellarModel() {
        this.myCellar = new CopyOnWriteArrayList();
        this.currentAttributeList = new ArrayList<String>(Arrays.asList(CellarBottle.defaultAttributeList));
        this.myCellarStats = new CellarStatistics();
    }

    public ArrayList<String> getCurrentAttributeList() {
        return this.currentAttributeList;
    }

    public void setCurrentAttributeList(ArrayList<String> currentAttributeList) {
        this.currentAttributeList = currentAttributeList;
        this.fireTableStructureChanged();
    }

    public CellarStatistics getMyCellarStats() {
        return this.myCellarStats;
    }

    public CellarBottle getRowBottle(int rowIndex) {
        return this.myCellar.get(rowIndex);
    }

    public CellarBottle setRowBottle(CellarBottle editedBottle, int rowIndex) {
        return this.myCellar.set(rowIndex, editedBottle);
    }

    @Override
    public int getRowCount() {
        return this.myCellar.size();
    }

    @Override
    public int getColumnCount() {
        return this.currentAttributeList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        for (int i = 0; i < CellarBottle.allAttributeList.length; ++i) {
            if (!this.currentAttributeList.get(columnIndex).equals(CellarBottle.allAttributeList[i])) continue;
            return this.myCellar.get(rowIndex).getAttribute(i);
        }
        return null;
    }

    @Override
    public String getColumnName(int i) {
        return this.currentAttributeList.get(i);
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < CellarBottle.allAttributeList.length; ++i) {
            if (!this.currentAttributeList.get(columnIndex).equals(CellarBottle.allAttributeList[i])) continue;
            return CellarBottle.allAttributeTypeList[i].attributeClass();
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        for (int i = 0; i < CellarBottle.allAttributeList.length; ++i) {
            if (!this.currentAttributeList.get(columnIndex).equals(CellarBottle.allAttributeList[i])) continue;
            return CellarBottle.allAttributeTypeList[i].equals((Object)CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST);
        }
        return false;
    }

    public void loadCellar(File cellarDatabase) throws FileNotFoundException, IOException, ClassNotFoundException {
        try (ObjectInputStream binInStream = null;){
            binInStream = new ObjectInputStream(new FileInputStream(cellarDatabase));
            this.myCellar = (CopyOnWriteArrayList)binInStream.readObject();
            for (CellarBottle curBottle : this.myCellar) {
                curBottle.updateExtraAttributeLists();
            }
            this.fireTableDataChanged();
            this.myCellarStats.updateStatistics(this.myCellar);
        }
    }

    public void loadCellar(URL cellarURL) throws IOException, ClassNotFoundException {
        try (ObjectInputStream binInStream = null;){
            binInStream = new ObjectInputStream(cellarURL.openStream());
            this.myCellar = (CopyOnWriteArrayList)binInStream.readObject();
            for (CellarBottle curBottle : this.myCellar) {
                curBottle.updateExtraAttributeLists();
            }
            this.fireTableDataChanged();
            this.myCellarStats.updateStatistics(this.myCellar);
        }
    }

    public void saveCellar(File cellarDatabase) throws FileNotFoundException, IOException {
        try (ObjectOutputStream binOutStream = null;){
            binOutStream = new ObjectOutputStream(new FileOutputStream(cellarDatabase));
            binOutStream.writeObject(this.myCellar);
        }
    }

    public void clearCellar() {
        this.myCellar = new CopyOnWriteArrayList();
        this.fireTableDataChanged();
        this.myCellarStats.updateStatistics(this.myCellar);
    }

    public void saveCellar(URL cellarURL) throws IOException {
        try (ObjectOutputStream binOutStream = null;){
            URLConnection connection = cellarURL.openConnection();
            connection.setDoOutput(true);
            binOutStream = new ObjectOutputStream(connection.getOutputStream());
            binOutStream.writeObject(this.myCellar);
        }
    }

    public ArrayList<CellarBottle> getSimilarBottles(CellarBottle refBottle) {
        ArrayList<CellarBottle> similarBottles = new ArrayList<CellarBottle>();
        for (int i = 0; i < this.myCellar.size(); ++i) {
            if (!refBottle.nearEquals(this.myCellar.get(i))) continue;
            similarBottles.add(this.myCellar.get(i));
        }
        return similarBottles;
    }

    public void addBottle(int rowIndex, int nbBottles) {
        CellarBottle curBottle = this.myCellar.get(rowIndex);
        curBottle.addBtle(nbBottles);
        this.myCellarStats.addBottles(nbBottles, curBottle.getCountry(), curBottle.getRegion(), curBottle.getType(), curBottle.toDrink(), curBottle.getContenance(), curBottle.getPrice());
        for (int j = 0; j < this.currentAttributeList.size(); ++j) {
            if (!this.currentAttributeList.get(j).equals(CellarBottle.ATTRIBUTES.BOTTLE_NB_STOCK.attribute())) continue;
            this.fireTableCellUpdated(rowIndex, j);
        }
    }

    public void addBottle(CellarBottle newBottle) throws SimilarBottleException {
        for (int i = 0; i < this.myCellar.size(); ++i) {
            if (!newBottle.nearEquals(this.myCellar.get(i))) continue;
            throw new SimilarBottleException(this.myCellar.get(i));
        }
        this.myCellar.add(newBottle);
        this.myCellarStats.addBottles(newBottle.getNbBtlesInStock(), newBottle.getCountry(), newBottle.getRegion(), newBottle.getType(), newBottle.toDrink(), newBottle.getContenance(), newBottle.getPrice());
        this.fireTableRowsInserted(this.myCellar.size() - 1, this.myCellar.size() - 1);
    }

    public void addBottleForce(CellarBottle newBottle) {
        this.myCellar.add(newBottle);
        this.myCellarStats.addBottles(newBottle.getNbBtlesInStock(), newBottle.getCountry(), newBottle.getRegion(), newBottle.getType(), newBottle.toDrink(), newBottle.getContenance(), newBottle.getPrice());
        this.fireTableRowsInserted(this.myCellar.size() - 1, this.myCellar.size() - 1);
    }

    public void takeBottle(int rowIndex, int nbBottles) throws InsufficientBottleException {
        CellarBottle curBottle = this.myCellar.get(rowIndex);
        curBottle.removeBtle(nbBottles);
        this.myCellarStats.takeBottles(nbBottles, curBottle.getCountry(), curBottle.getRegion(), curBottle.getType(), curBottle.toDrink(), curBottle.getContenance(), curBottle.getPrice());
        for (int j = 0; j < this.currentAttributeList.size(); ++j) {
            if (!this.currentAttributeList.get(j).equals(CellarBottle.ATTRIBUTES.BOTTLE_NB_STOCK.attribute())) continue;
            this.fireTableCellUpdated(rowIndex, j);
        }
    }

    public void removeBottle(int rowIndex) {
        CellarBottle curBottle = this.myCellar.get(rowIndex);
        this.myCellarStats.removeBottles(curBottle.getNbBtlesInStock(), curBottle.getCountry(), curBottle.getRegion(), curBottle.getType(), curBottle.toDrink(), curBottle.getContenance(), curBottle.getPrice());
        this.myCellar.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void removeBottle(UUID bottleID) {
        for (int i = 0; i < this.myCellar.size(); ++i) {
            if (!bottleID.equals(this.myCellar.get(i).getBtleID())) continue;
            CellarBottle curBottle = this.myCellar.get(i);
            this.myCellarStats.removeBottles(curBottle.getNbBtlesInStock(), curBottle.getCountry(), curBottle.getRegion(), curBottle.getType(), curBottle.toDrink(), curBottle.getContenance(), curBottle.getPrice());
            this.myCellar.remove(i);
            this.fireTableRowsDeleted(i, i);
            return;
        }
    }
}

