/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.business;

import ch.hearc.masict.jav.business.CellarBottle;
import java.util.Calendar;

public class WineCellarBottle
extends CellarBottle {
    private static final long serialVersionUID = 8484294087547820211L;
    public static final String WINECELLARBOTTLE = "WineCellarBottle";
    private int year;
    private String[] grapes;
    private int yearToDrinkFrom;
    private int yearToDrinkTo;

    public WineCellarBottle() {
        int i;
        this.year = 0;
        this.yearToDrinkFrom = 0;
        this.yearToDrinkTo = 0;
        this.grapes = new String[]{""};
        this.typeList = new String[WINE_TYPE.values().length];
        for (i = 0; i < WINE_TYPE.values().length; ++i) {
            this.typeList[i] = WINE_TYPE.values()[i].wineType;
        }
        this.extraAttributeList = new String[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].attribute;
        }
        this.extraAttributeTypeList = new CellarBottle.ATTRIBUTE_TYPES[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeTypeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].type;
        }
        if (!CellarBottle.subClassList.contains(WINECELLARBOTTLE)) {
            CellarBottle.subClassList.add(WINECELLARBOTTLE);
        }
        this.subClass = WINECELLARBOTTLE;
    }

    public WineCellarBottle(String name, String producer, String country, String region, String type, String[] food, String description, String labelFront, String labelBack, int contenance, double alcoholPercent, double price, double rating, int year, int yearToDrinkFrom, int yearToDrinkTo, String[] grapes) {
        super(name, producer, country, region, type, food, description, labelFront, labelBack, contenance, alcoholPercent, price, rating);
        int i;
        this.year = year;
        this.yearToDrinkFrom = yearToDrinkFrom;
        this.yearToDrinkTo = yearToDrinkTo;
        this.grapes = new String[]{""};
        if (grapes != null) {
            this.grapes = grapes;
        }
        this.typeList = new String[WINE_TYPE.values().length];
        for (i = 0; i < WINE_TYPE.values().length; ++i) {
            this.typeList[i] = WINE_TYPE.values()[i].wineType;
        }
        this.extraAttributeList = new String[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].attribute;
        }
        this.extraAttributeTypeList = new CellarBottle.ATTRIBUTE_TYPES[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeTypeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].type;
        }
        if (!CellarBottle.subClassList.contains(WINECELLARBOTTLE)) {
            CellarBottle.subClassList.add(WINECELLARBOTTLE);
        }
        this.subClass = WINECELLARBOTTLE;
    }

    @Override
    public Object getExtraAttribute(int attributeIndex) {
        switch (WINE_EXTRA_ATTRIBUTES.values()[attributeIndex]) {
            case YEAR: {
                return this.year;
            }
            case GRAPES: {
                return this.grapes;
            }
            case YEAR_FROM: {
                return this.yearToDrinkFrom;
            }
            case YEAR_TO: {
                return this.yearToDrinkTo;
            }
        }
        return null;
    }

    @Override
    public void setExtraAttribute(int attributeIndex, Object attribute) {
        switch (WINE_EXTRA_ATTRIBUTES.values()[attributeIndex]) {
            case YEAR: {
                this.year = (Integer)attribute;
                break;
            }
            case GRAPES: {
                this.grapes = (String[])attribute;
                break;
            }
            case YEAR_FROM: {
                this.yearToDrinkFrom = (Integer)attribute;
                break;
            }
            case YEAR_TO: {
                this.yearToDrinkTo = (Integer)attribute;
            }
        }
    }

    @Override
    public String[] getDropExtraAttributeLists(int attributeIndex) {
        switch (WINE_EXTRA_ATTRIBUTES.values()[attributeIndex]) {
            default: 
        }
        return null;
    }

    public void setYearToDrinkFrom(int yearToDrinkFrom) {
        this.yearToDrinkFrom = yearToDrinkFrom;
    }

    public void setNbYearToKeepMin(int nbYearToKeepMin) {
        this.yearToDrinkFrom = this.year + nbYearToKeepMin;
    }

    public void setYearToDrinkTo(int yearToDrinkTo) {
        this.yearToDrinkTo = yearToDrinkTo;
    }

    public void setNbYearToKeepMax(int nbYearToKeepMax) {
        this.yearToDrinkTo = this.year + nbYearToKeepMax;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public String[] getGrapes() {
        return this.grapes;
    }

    public void setGrapes(String[] grapes) {
        this.grapes = grapes;
    }

    @Override
    public boolean toDrink() {
        int curYear = Calendar.getInstance().get(1);
        if (this.yearToDrinkFrom != 0 && this.yearToDrinkTo != 0 && curYear >= this.yearToDrinkFrom && curYear <= this.yearToDrinkTo) {
            return true;
        }
        for (WINE_TYPE wst : WINE_TYPE.values()) {
            if (!wst.wineType.equals(this.getType())) continue;
            return curYear >= this.year + wst.toKeepMin && curYear <= this.year + wst.toKeppMax;
        }
        return true;
    }

    @Override
    public boolean nearEquals(CellarBottle bottle) {
        if (!super.equals(bottle)) {
            return false;
        }
        if (bottle.getClass() == this.getClass()) {
            WineCellarBottle testWineBottle = (WineCellarBottle)bottle;
            if (this.year != testWineBottle.year) {
                return false;
            }
            for (int i = 0; i < this.grapes.length; ++i) {
                int j = 0;
                if (j >= testWineBottle.grapes.length || testWineBottle.grapes[j].equalsIgnoreCase(this.grapes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean nearEquals(String name, String producer, String country, String region, String type, int contenance) {
        throw new UnsupportedOperationException();
    }

    public boolean nearEquals(String name, String producer, String country, String region, String type, int contenance, int year, String[] grapes) {
        if (!super.nearEquals(name, producer, country, region, type, contenance)) {
            return false;
        }
        if (this.year != year) {
            return false;
        }
        for (int i = 0; i < this.grapes.length; ++i) {
            int j = 0;
            if (j >= grapes.length || grapes[j].equalsIgnoreCase(this.grapes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateExtraAttributeLists() {
        int i;
        this.typeList = new String[WINE_TYPE.values().length];
        for (i = 0; i < WINE_TYPE.values().length; ++i) {
            this.typeList[i] = WINE_TYPE.values()[i].wineType;
        }
        this.extraAttributeList = new String[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].attribute;
        }
        this.extraAttributeTypeList = new CellarBottle.ATTRIBUTE_TYPES[WINE_EXTRA_ATTRIBUTES.values().length];
        for (i = 0; i < WINE_EXTRA_ATTRIBUTES.values().length; ++i) {
            this.extraAttributeTypeList[i] = WINE_EXTRA_ATTRIBUTES.values()[i].type;
        }
    }

    public static enum WINE_EXTRA_ATTRIBUTES {
        YEAR("Year", CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR),
        GRAPES("Grapes", CellarBottle.ATTRIBUTE_TYPES.TEXT_LIST),
        YEAR_FROM("Drink from", CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR),
        YEAR_TO("Drink to", CellarBottle.ATTRIBUTE_TYPES.VALUE_YEAR);

        private final String attribute;
        private final CellarBottle.ATTRIBUTE_TYPES type;

        private WINE_EXTRA_ATTRIBUTES(String attribute, CellarBottle.ATTRIBUTE_TYPES type) {
            this.attribute = attribute;
            this.type = type;
        }

        public String attribut() {
            return this.attribute;
        }

        public CellarBottle.ATTRIBUTE_TYPES type() {
            return this.type;
        }
    }

    public static enum WINE_TYPE {
        LIGHT_RED("Light Red Wine", 0, 5),
        STRONG_RED("Strong Red Wine", 4, 20),
        SWEET_RED("Sweet Red Wine", 0, 15),
        DRY_ROSE("Dry Ros\u00e9 Wine", 0, 3),
        SWEET_ROSE("Sweet Ros\u00e9 Wine", 0, 5),
        LIGHT_WHITE("Light White Wine", 0, 5),
        HEAY_WHITE("Heavy White Wine", 2, 10),
        SWEET_WHITE("Sweet White Wine", 0, 15),
        WHITE_FROM_RED("White from Red Wine", 0, 5),
        SPARKILNG_RED("Sparkling Red Wine", 0, 5),
        SPARKINLG_WHITE("Sparkling White Wine", 0, 3);

        private final String wineType;
        private final int toKeepMin;
        private final int toKeppMax;

        private WINE_TYPE(String type, int toKeepMin, int toKeppMax) {
            this.wineType = type;
            this.toKeepMin = toKeepMin;
            this.toKeppMax = toKeppMax;
        }

        public int toKeepMin() {
            return this.toKeepMin;
        }

        public int toKeppMax() {
            return this.toKeppMax;
        }

        public String wineType() {
            return this.wineType;
        }
    }
}

