/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import ch.hearc.masict.jav.view.ImageFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ImagePanel
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    private static final int IMAGE_WIDTH = 480;
    private static final int IMAGE_HEIGHT = 640;
    private BufferedImage image;
    private BufferedImage originalImage;
    private BufferedImage modifiedOriginalImage;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int cropping;
    private int width = 480;
    private int height = 640;
    private JPopupMenu imagePopupMenu;
    private JMenu popMenuRotateImage;
    private JMenuItem popMenuLoadImage;
    private JMenuItem popMenuRotateImagePlus90;
    private JMenuItem popMenuRotateImage180;
    private JMenuItem popMenuRotateImageMinus90;
    private JMenuItem popMenuResetImage;
    private JMenuItem popMenuCropImage;
    private JMenuItem popMenuRemoveImage;
    private JMenuItem popMenuSearchInfo;
    private JFileChooser imageFileChooser;

    public ImagePanel() {
        this.initComponents();
    }

    public ImagePanel(BufferedImage newImage) {
        if (this.image != null) {
            this.originalImage = newImage;
            this.modifiedOriginalImage = newImage;
            Image scaledImage = newImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.image = bufferedImage;
        } else {
            this.image = null;
            this.originalImage = null;
            this.modifiedOriginalImage = null;
        }
        this.initComponents();
    }

    public void setImage(BufferedImage image) {
        if (image != null) {
            this.originalImage = image;
            this.modifiedOriginalImage = image;
            Image scaledImage = image.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
        } else {
            this.image = null;
            this.originalImage = null;
            this.modifiedOriginalImage = null;
        }
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void initComponents() {
        this.popMenuLoadImage = new JMenuItem("Load new image...");
        this.popMenuLoadImage.addActionListener(this);
        this.popMenuRotateImage = new JMenu("Rotate image");
        this.popMenuRotateImagePlus90 = new JMenuItem("Rotate +90\u00b0");
        this.popMenuRotateImagePlus90.addActionListener(this);
        this.popMenuRotateImageMinus90 = new JMenuItem("Rotate -90\u00b0");
        this.popMenuRotateImageMinus90.addActionListener(this);
        this.popMenuRotateImage180 = new JMenuItem("180\u00b0");
        this.popMenuRotateImage180.addActionListener(this);
        this.popMenuRotateImage.add(this.popMenuRotateImagePlus90);
        this.popMenuRotateImage.add(this.popMenuRotateImageMinus90);
        this.popMenuRotateImage.add(this.popMenuRotateImage180);
        this.popMenuCropImage = new JMenuItem("Crop image...");
        this.popMenuCropImage.addActionListener(this);
        this.popMenuResetImage = new JMenuItem("Reset image");
        this.popMenuResetImage.addActionListener(this);
        this.popMenuRemoveImage = new JMenuItem("Remove image");
        this.popMenuRemoveImage.addActionListener(this);
        this.popMenuSearchInfo = new JMenuItem("Search Info...");
        this.popMenuSearchInfo.addActionListener(this);
        this.imagePopupMenu = new JPopupMenu();
        this.imagePopupMenu.add(this.popMenuLoadImage);
        this.imagePopupMenu.add(this.popMenuRotateImage);
        this.imagePopupMenu.add(this.popMenuCropImage);
        this.imagePopupMenu.add(this.popMenuResetImage);
        this.imagePopupMenu.add(this.popMenuRemoveImage);
        this.setComponentPopupMenu(this.imagePopupMenu);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.imageFileChooser = new JFileChooser();
        this.imageFileChooser.setFileSelectionMode(0);
        this.imageFileChooser.addChoosableFileFilter(new ImageFilter());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.cropping = 0;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.imagePopupMenu.setEnabled(enabled);
        this.popMenuLoadImage.setEnabled(enabled);
        this.popMenuRotateImage.setEnabled(enabled);
        this.popMenuRotateImagePlus90.setEnabled(enabled);
        this.popMenuRotateImageMinus90.setEnabled(enabled);
        this.popMenuRotateImage180.setEnabled(enabled);
        this.popMenuCropImage.setEnabled(enabled);
        this.popMenuResetImage.setEnabled(enabled);
        this.popMenuRemoveImage.setEnabled(enabled);
        this.popMenuSearchInfo.setEnabled(enabled);
    }

    @Override
    protected void paintComponent(Graphics grphcs) {
        Dimension cellDimension = this.getSize();
        super.paintComponent(grphcs);
        Graphics2D g2d = (Graphics2D)grphcs;
        if (this.image == null) {
            grphcs.drawString("Not Found", cellDimension.width / 2 - 25, cellDimension.height / 2 + 5);
        } else {
            g2d.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        }
        if (this.cropping == 2) {
            grphcs.setColor(Color.RED);
            grphcs.drawRect(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.max(this.x1 - this.x2, this.x2 - this.x1), Math.max(this.y1 - this.y2, this.y2 - this.y1));
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.popMenuLoadImage) {
            File imgFile;
            this.imageFileChooser.setDialogTitle("Load Image...");
            int returnVal = this.imageFileChooser.showOpenDialog(this.popMenuLoadImage);
            if (returnVal == 0 && (imgFile = this.imageFileChooser.getSelectedFile()).exists()) {
                try {
                    this.setImage(ImageIO.read(imgFile));
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.popMenuLoadImage, "Error loading image file. Please retry or contact administrator.", "Image loading error", 0);
                }
            }
            return;
        }
        if (src == this.popMenuRotateImagePlus90) {
            BufferedImage newImage = new BufferedImage(this.modifiedOriginalImage.getHeight(), this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getType());
            Graphics2D graphics = (Graphics2D)newImage.getGraphics();
            graphics.rotate(Math.toRadians(90.0));
            graphics.translate(0, -newImage.getWidth());
            graphics.drawImage(this.modifiedOriginalImage, 0, 0, this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getHeight(), null);
            this.modifiedOriginalImage = newImage;
            Image scaledImage = this.modifiedOriginalImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
            this.revalidate();
            this.repaint();
            return;
        }
        if (src == this.popMenuRotateImageMinus90) {
            BufferedImage newImage = new BufferedImage(this.modifiedOriginalImage.getHeight(), this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getType());
            Graphics2D graphics = (Graphics2D)newImage.getGraphics();
            graphics.rotate(Math.toRadians(-90.0));
            graphics.translate(-newImage.getHeight(), 0);
            graphics.drawImage(this.modifiedOriginalImage, 0, 0, this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getHeight(), null);
            this.modifiedOriginalImage = newImage;
            Image scaledImage = this.modifiedOriginalImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
            this.revalidate();
            this.repaint();
            return;
        }
        if (src == this.popMenuRotateImage180) {
            BufferedImage newImage = new BufferedImage(this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getHeight(), this.modifiedOriginalImage.getType());
            Graphics2D graphics = (Graphics2D)newImage.getGraphics();
            graphics.rotate(Math.toRadians(180.0));
            graphics.translate(-newImage.getWidth(), -newImage.getHeight());
            graphics.drawImage(this.modifiedOriginalImage, 0, 0, this.modifiedOriginalImage.getWidth(), this.modifiedOriginalImage.getHeight(), null);
            this.modifiedOriginalImage = newImage;
            Image scaledImage = this.modifiedOriginalImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
            this.revalidate();
            this.repaint();
            return;
        }
        if (src == this.popMenuResetImage) {
            this.modifiedOriginalImage = this.originalImage;
            Image scaledImage = this.originalImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
            this.revalidate();
            this.repaint();
            return;
        }
        if (src == this.popMenuRemoveImage) {
            this.originalImage = null;
            this.modifiedOriginalImage = null;
            this.firePropertyChange("image", this.image, null);
            this.image = null;
            this.revalidate();
            this.repaint();
            return;
        }
        if (src == this.popMenuCropImage) {
            this.cropping = 1;
            return;
        }
        if (src == this.popMenuSearchInfo) {
            return;
        }
        throw new UnsupportedOperationException("Action is not supported yet.");
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.cropping == 1) {
            this.x1 = me.getX();
            this.y1 = me.getY();
            this.x2 = me.getX();
            this.y2 = me.getY();
            this.repaint();
            this.cropping = 2;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (this.cropping == 2) {
            BufferedImage cropImage;
            this.x2 = me.getX();
            this.y2 = me.getY();
            this.cropping = 0;
            this.modifiedOriginalImage = cropImage = this.modifiedOriginalImage.getSubimage(Math.min(this.x1, this.x2) * this.modifiedOriginalImage.getWidth() / this.getWidth(), Math.min(this.y1, this.y2) * this.modifiedOriginalImage.getHeight() / this.getHeight(), Math.max(this.x1 - this.x2, this.x2 - this.x1) * this.modifiedOriginalImage.getWidth() / this.getWidth(), Math.max(this.y1 - this.y2, this.y2 - this.y1) * this.modifiedOriginalImage.getHeight() / this.getHeight());
            Image scaledImage = this.modifiedOriginalImage.getScaledInstance(this.width, this.height, 4);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            bufferedImage.getGraphics().drawImage(scaledImage, 0, 0, null);
            this.firePropertyChange("image", this.image, bufferedImage);
            this.image = bufferedImage;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.cropping == 2) {
            this.x2 = me.getX();
            this.y2 = me.getY();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultipartEntityBuilder constructPostSearchRequest(String imagePath) {
        MultipartEntityBuilder postRequestBody = MultipartEntityBuilder.create();
        try {
            File imgFile = new File(imagePath);
            String imgType = Files.probeContentType(imgFile.toPath());
            FileBody postImage = new FileBody(imgFile, imgType);
            postRequestBody.addPart("image", postImage);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "Image file not found.", "Image not found", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error finding image type. Please retry or change image.", "Image type detection error", 0);
        }
        finally {
            return postRequestBody;
        }
    }

    public String search(String apiUrl, String imagePath, String authHost, String authUsername, String authPassword) throws IOException {
        MultipartEntityBuilder searchPostRequestBody = this.constructPostSearchRequest(imagePath);
        return this.doPost(apiUrl, searchPostRequestBody, authHost, authUsername, authPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doPost(String apiUrl, MultipartEntityBuilder postRequestBody, String authHost, String authUsername, String authPassword) throws IOException {
        CloseableHttpClient httpClient = this.setUpHttpClientWithAuth(authHost, authUsername, authPassword);
        HttpEntity responseEntity = null;
        String apiResponseContent = null;
        try {
            HttpPost httpPost = new HttpPost(apiUrl);
            httpPost.setEntity(postRequestBody.build());
            CloseableHttpResponse apiResponse = httpClient.execute((HttpUriRequest)httpPost);
            responseEntity = apiResponse.getEntity();
            if (responseEntity != null) {
                apiResponseContent = IOUtils.toString(responseEntity.getContent());
            }
            EntityUtils.consume((HttpEntity)responseEntity);
            httpClient.close();
        }
        catch (IOException e) {
            apiResponseContent = null;
            return apiResponseContent;
        }
        finally {
            return apiResponseContent;
        }
    }

    private CloseableHttpClient setUpHttpClientWithAuth(String authHost, String authUsername, String authPassword) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        BasicCredentialsProvider myCredentials = new BasicCredentialsProvider();
        myCredentials.setCredentials(new AuthScope(authHost, -1), (Credentials)new UsernamePasswordCredentials(authUsername, authPassword));
        httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)myCredentials);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }
}

