/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LabelCellRenderer
extends DefaultTableCellRenderer {
    private BufferedImage cellLabel;
    private String databasePath;

    public LabelCellRenderer(String databasePath) {
        this.databasePath = databasePath;
    }

    public void setDatabasePath(String databasePath) {
        this.databasePath = databasePath;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        File imgFile = new File(this.databasePath + (String)value);
        if (imgFile.exists()) {
            try {
                this.cellLabel = ImageIO.read(imgFile);
            }
            catch (IOException ex) {
                this.cellLabel = null;
            }
        }
        this.setText("");
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension cellDimension = this.getSize();
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.cellLabel == null) {
            g.drawString("Not Found", cellDimension.width / 2 - 25, cellDimension.height / 2 + 5);
        } else {
            g2d.drawImage(this.cellLabel, 1, 1, cellDimension.width - 1, cellDimension.height - 1, null);
        }
    }
}

