/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RatingCellRenderer
extends DefaultTableCellRenderer {
    private BufferedImage cellImage;
    private BufferedImage fullImage;
    private final int IMG_MIN_HEIGHT = 10;

    public RatingCellRenderer() {
        try {
            this.fullImage = ImageIO.read(this.getClass().getResource("/ch/hearc/masict/jav/img/rating_stars.png"));
            this.cellImage = this.fullImage.getSubimage(0, 0, 94, 15);
        }
        catch (IOException ex) {
            this.fullImage = null;
            this.cellImage = null;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        double ratingValue = (Double)value;
        int yCropStart = (int)(ratingValue *= 2.0) * 22;
        if (this.fullImage != null) {
            this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension cellDimension = this.getSize();
        super.paintComponent(g);
        if (this.cellImage != null) {
            Graphics2D g2d = (Graphics2D)g;
            int newHeight = (int)((double)this.cellImage.getHeight() * ((double)(cellDimension.width - 2) / (double)this.cellImage.getWidth()));
            if (newHeight < 10) {
                newHeight = 10;
            } else if (newHeight > cellDimension.height - 8) {
                newHeight = cellDimension.height - 8;
            }
            int newWidth = (int)((double)this.cellImage.getWidth() * ((double)newHeight / (double)this.cellImage.getHeight()));
            g2d.drawImage(this.cellImage, 1, (cellDimension.height - newHeight) / 2, newWidth, newHeight, null);
        }
    }
}

