/*
 * Decompiled with CFR 0.152.
 */
package ch.hearc.masict.jav.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JLabel;

public class RatingLabel
extends JLabel
implements MouseMotionListener,
MouseListener {
    private int rateValue;
    private boolean editable;
    private BufferedImage cellImage;
    private BufferedImage fullImage;
    private final int PREF_HEIGHT = 18;
    private final int PREF_WIDTH = 88;
    private final int IMG_MIN_HEIGHT = 10;

    public RatingLabel() {
        this.setEnabled(false);
        this.rateValue = 0;
        try {
            this.fullImage = ImageIO.read(this.getClass().getResource("/ch/hearc/masict/jav/img/rating_stars.png"));
            this.cellImage = this.fullImage.getSubimage(0, 0, 94, 15);
            this.setText("");
        }
        catch (IOException ex) {
            this.fullImage = null;
            this.cellImage = null;
            this.setText("0");
        }
        this.setPreferredSize(new Dimension(88, 18));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public RatingLabel(double rate) {
        this.setEnabled(false);
        this.rateValue = (int)rate * 2;
        try {
            this.fullImage = ImageIO.read(this.getClass().getResource("/ch/hearc/masict/jav/img/rating_stars.png"));
            int yCropStart = this.rateValue * 22;
            this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
            this.setText("");
        }
        catch (IOException ex) {
            this.fullImage = null;
            this.cellImage = null;
            this.setText(String.valueOf(rate));
        }
        this.setPreferredSize(new Dimension(88, 18));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public double getRateValue() {
        return (double)this.rateValue / 2.0;
    }

    public void setRateValue(double rateValue) {
        this.rateValue = (int)rateValue * 2;
        int yCropStart = this.rateValue * 22;
        if (this.fullImage != null) {
            this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
            this.setText("");
        } else {
            this.setText(String.valueOf(rateValue));
        }
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Dimension cellDimension = this.getSize();
        super.paintComponent(g);
        if (this.cellImage != null) {
            Graphics2D g2d = (Graphics2D)g;
            int newHeight = (int)((double)this.cellImage.getHeight() * ((double)(cellDimension.width - 2) / (double)this.cellImage.getWidth()));
            if (newHeight < 10) {
                newHeight = 10;
            } else if (newHeight > cellDimension.height - 4) {
                newHeight = cellDimension.height - 4;
            }
            int newWidth = (int)((double)this.cellImage.getWidth() * ((double)newHeight / (double)this.cellImage.getHeight()));
            g2d.drawImage(this.cellImage, 1, (cellDimension.height - newHeight) / 2, newWidth, newHeight, null);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (this.editable) {
            double labelWidth = this.getWidth();
            double mouseX = me.getX();
            int mouseRateValue = (int)(10.0 * (mouseX / labelWidth) + 0.5);
            int yCropStart = mouseRateValue * 22;
            if (this.fullImage != null) {
                this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
                this.setText("");
            } else {
                this.setText(String.valueOf(mouseRateValue / 2));
            }
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (this.editable) {
            int labelWidth = this.getWidth();
            double mouseX = me.getX();
            this.rateValue = (int)(10.0 * (mouseX / (double)labelWidth) + 0.5);
            int yCropStart = this.rateValue * 22;
            if (this.fullImage != null) {
                this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
                this.setText("");
            } else {
                this.setText(String.valueOf(this.rateValue / 2));
            }
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
        if (this.fullImage != null) {
            int yCropStart = this.rateValue * 22;
            this.cellImage = this.fullImage.getSubimage(0, yCropStart, 94, 15);
            this.setText("");
        } else {
            this.setText(String.valueOf(this.rateValue / 2));
        }
        this.repaint();
    }
}

